local c;
local cf;
local canAnimate = false;
local player = Var "Player";
local ShowComboAt = THEME:GetMetric("Combo", "ShowComboAt");
local Pulse = THEME:GetMetric("Combo", "PulseCommand");
local PulseLabel = THEME:GetMetric("Combo", "PulseLabelCommand");

local NumberMinZoom = THEME:GetMetric("Combo", "NumberMinZoom");
local NumberMaxZoom = THEME:GetMetric("Combo", "NumberMaxZoom");
local NumberMaxZoomAt = THEME:GetMetric("Combo", "NumberMaxZoomAt");

local LabelMinZoom = THEME:GetMetric("Combo", "LabelMinZoom");
local LabelMaxZoom = THEME:GetMetric("Combo", "LabelMaxZoom");

local ShowFlashyCombo = ThemePrefs.Get("FlashyCombo")

local t = Def.ActorFrame {
	InitCommand=cmd(vertalign,bottom);
	-- flashy combo elements:
 	LoadActor(THEME:GetPathG("Combo","100Milestone")) .. {
		Name="OneHundredMilestone";
		InitCommand=cmd(visible,ShowFlashyCombo);
		FiftyMilestoneCommand=cmd(playcommand,"Milestone");
	};
	LoadActor(THEME:GetPathG("Combo","1000Milestone")) .. {
		Name="OneThousandMilestone";
		InitCommand=cmd(visible,ShowFlashyCombo);
		ToastyAchievedMessageCommand=cmd(playcommand,"Milestone");
	};
	-- normal combo elements:
	Def.ActorFrame {
		Name="ComboFrame";
		LoadFont( "Combo", "numbers" ) .. {
			Name="Number";
			OnCommand = THEME:GetMetric("Combo", "NumberOnCommand");
		};
		LoadActor("_combo")..{
			Name="ComboLabel";
			OnCommand = THEME:GetMetric("Combo", "ComboLabelOnCommand");
		};
		LoadActor("_misses")..{
			Name="MissLabel";
			OnCommand = THEME:GetMetric("Combo", "MissLabelOnCommand");
		};
	};
	InitCommand = function(self)
		c = self:GetChildren();
		cf = c.ComboFrame:GetChildren();
		cf.Number:visible(false);
		cf.ComboLabel:visible(false)
		cf.MissLabel:visible(false)
	end;

	ComboCommand=function(self, param)
		local iCombo = param.Misses or param.Combo;
		if not iCombo or iCombo < ShowComboAt then
			cf.Number:visible(false);
			cf.ComboLabel:visible(false)
			cf.MissLabel:visible(false)
			return;
		end

		cf.ComboLabel:visible(false)
		cf.MissLabel:visible(false)

		if param.Combo then
			cf.ComboLabel:visible(true)
			cf.MissLabel:visible(false)
		else
			cf.ComboLabel:visible(false)
			cf.MissLabel:visible(true)
		end

		param.Zoom = scale( iCombo, 0, NumberMaxZoomAt, NumberMinZoom, NumberMaxZoom );
		param.Zoom = clamp( param.Zoom, NumberMinZoom, NumberMaxZoom );

		param.LabelZoom = scale( iCombo, 0, NumberMaxZoomAt, LabelMinZoom, LabelMaxZoom );
		param.LabelZoom = clamp( param.LabelZoom, LabelMinZoom, LabelMaxZoom );

		cf.Number:visible(true);
		cf.Number:finishtweening();
		cf.Number:settext( string.format("%i", iCombo) );
		-- FullCombo Rewards
		if param.FullComboW1 then
			cf.Number:diffuse( GameColor.Judgment["JudgmentLine_W1"] );
			cf.Number:strokecolor( GameColor.Judgment["JudgmentLine_W1"] );
			cf.ComboLabel:diffuse( GameColor.Judgment["JudgmentLine_W1"] );
            cf.Number:glowshift();
			cf.ComboLabel:glowshift();
		elseif param.FullComboW2 then
			cf.Number:diffuse( GameColor.Judgment["JudgmentLine_W2"] );
			cf.Number:strokecolor( GameColor.Judgment["JudgmentLine_W2"] );
			cf.ComboLabel:diffuse( GameColor.Judgment["JudgmentLine_W2"] );
			cf.Number:glowshift();
			cf.ComboLabel:glowshift();
		elseif param.FullComboW3 then
			cf.Number:diffuse( GameColor.Judgment["JudgmentLine_W3"] );
			cf.Number:strokecolor( GameColor.Judgment["JudgmentLine_W3"] );
			cf.ComboLabel:diffuse( GameColor.Judgment["JudgmentLine_W3"] );
			cf.Number:glowshift();
			cf.ComboLabel:glowshift();
		elseif param.FullComboW4 then
			cf.Number:diffuse( GameColor.Judgment["JudgmentLine_W4"] );
			cf.Number:strokecolor( GameColor.Judgment["JudgmentLine_W4"] );
			cf.ComboLabel:diffuse( GameColor.Judgment["JudgmentLine_W4"] );
			cf.Number:glowshift();
			cf.ComboLabel:glowshift();
		elseif param.Combo then
			cf.Number:diffuse(Color("White"));
			cf.Number:strokecolor(Color("White"));
			cf.ComboLabel:diffuse(Color("White"));
			cf.Number:glowshift();
		else
			cf.Number:stopeffect();
		end

		Pulse( cf.Number, param );
		if param.Combo then
			Pulse( cf.Number, param );
			PulseLabel( cf.ComboLabel, param );
		else
			Pulse( cf.Number, param );
			PulseLabel( cf.MissLabel, param );
		end
	end;
};

return t;
